/*
Hack Name: Header Links Control Advanced v2.0

Hack Author: GuldantheWarlock (GuldantheWarlock@xmbgarage.com)

Last Updated: March 13, 2009

Hack Description:
This modification will allow you to specify sub-links for your header links through the admin panel.
This modification will display all sub-links in a JavaScript drop down menu under the specified link.
This modification also includes the features for Header Link Controls Advanced:
 - This modification will provide controls for the number of header links per line via Admin Panel -> Settings.
 - This modification will will provide on/off controls for the link images in Admin Panel -> Settings.
 - This modification will allow you to enter a separator for the links in Admin Panel -> Settings.

Supported Version: XMB 1.9.5 Nexus

Notes:

This modification uses some code from Header Links Control Advanced by Adam Clarke (http://www.xmbservices.com/) and myself

This modification is released under the GPL. You should have recieved a copy of it with this modification.

Please backup your files before installing this modification. Neither XMBGarage nor the author can be held
responsible if your board stops functioning properly due to you installing this hack.
*/

var headerLinks = new Array();
var headerSubmenus = new Array();
var hideTimeout;
var hideDelay   = 300;

function addEvent(obj, evt, func) {
    if (window.attachEvent) {
        obj.attachEvent('on'+evt, func);
    } else {
        obj.addEventListener(evt, func, false);
    }
}

function registerLoadFunc(func) {
    addEvent(window, 'load', func);
}

function $(el) {
    return document.getElementById(el);
}

function getElementByClassName(class_name, parentObj) {
    parentObj = (typeof parentObj != 'undefined') ? parentObj : document;
    for(var i=0; i<parentObj.elements.length; i++) {
        if (parentObj.elements[i].className == class_name) {
            return parentObj.elements[i];
        }
    }
}

function extractId(obj) {
    if(obj.tagName == 'A') {
        return obj.className.split('-')[2];
    } else {
        return obj.id.split('-')[2];
    }
}

function initializeMenuItems() {
    docLinks = document.getElementsByTagName('a');
    //Load appropraite anchors into headerLinks
    var j = 0;
    for(var i = 0;i<docLinks.length;i++) {
        if (docLinks[i].className.indexOf('header-link') > -1) {
            headerLinks[j++] = docLinks[i];
        }
    }

    for(i = 0; i<headerLinks.length; i++) {
        headerSubmenus[i] = $('sub-links-'+extractId(headerLinks[i]));
        headerSubmenus[i].onmouseover = function() { clearTimeout(hideTimeout); };
        headerSubmenus[i].onmouseout  = function() { delayHide(extractId(this)); };
        headerLinks[i].onmouseover = function() { showMenu(this, extractId(this)); };
        headerLinks[i].onmouseout  = function() { delayHide(extractId(this)); };
    }
}

function showMenu(obj, id) {
    hideAllMenus();
    menuDiv = $('sub-links-'+id);
    menuDiv.style.display = '';
    menuDiv.x = getPosOffset(obj, 'left');
    menuDiv.y = getPosOffset(obj, 'top');
    menuDiv.style.left = menuDiv.x - clearBrowserEdge(obj, 'rightedge')+'px';
    menuDiv.style.top  = menuDiv.y - clearBrowserEdge(obj, 'bottomedge') + obj.offsetHeight+'px';
}

function hideMenu(id) {
    document.getElementById('sub-links-'+id).style.display = 'none';
}

function hideAllMenus() {
    for(var i=0; i<headerSubmenus.length; i++) {
        headerSubmenus[i].style.display = 'none';
    }
}

function delayHide(id) {
    hideTimeout = setTimeout("hideMenu("+id+");", hideDelay);
}

function retrieveMenuObj(linkObj) {
    parts = linkObj.className.split('-');
    return document.getElementById('sub-links-'+parts[2]);
}

function getPosOffset(obj, offsetType) {
    var totaloffset = (offsetType == 'left') ? obj.offsetLeft : obj.offsetTop;
    var parentEl    = obj.offsetParent;
    while(parentEl != null) {
        totaloffset = (offsetType == 'left') ? totaloffset + parentEl.offsetLeft : totaloffset+parentEl.offsetTop;
        parentEl    = parentEl.offsetParent;
    }

    return totaloffset;
}

function clearBrowserEdge(obj, edge){
    var offSet  = 0;
    var menuObj = retrieveMenuObj(obj);

    if (edge == 'rightedge') {
        var windowedge = (document.all && !window.opera) ? document.body.scrollLeft + document.body.clientWidth - 15 : window.pageXOffset + window.innerWidth - 15;
        menuObj.contentmeasure = menuObj.offsetWidth;
        if (windowedge - menuObj.x < menuObj.contentmeasure) {
            offSet = menuObj.contentmeasure - obj.offsetWidth;
        }
    } else {
        var topedge = (document.all && !window.opera) ? document.body.scrollTop : window.pageYOffset;
        var windowedge = (document.all && !window.opera) ? document.body.scrollTop + document.body.clientHeight - 15 : window.pageYOffset + window.innerHeight - 18;
        menuObj.contentmeasure = menuObj.offsetHeight;
        if (windowedge - menuObj.y < menuObj.contentmeasure) { //move up?
            offSet = menuObj.contentmeasure + obj.offsetHeight;
            if ((menuObj.y - topedge) < menuObj.contentmeasure) { //up no good either?
                offSet = menuObj.y + obj.offsetHeight - topedge;
            }
        }
    }

    return offSet;
}

function checkHLForm(message) {
    if (typeof headerLinkIDs == 'undefined' || headerLinkIDs.length == 0) {
        return true;
    }

    var message = (message.length) ? message : '';

    var delChecked = false;
    for(var i = 0;i<headerLinkIDs.length;i++) {
        headerLink = document.getElementById('delete'+headerLinkIDs[i]);
        if (headerLink.checked == true) {
            delChecked = true;
        }
    }

    return (delChecked == true) ? confirm(hlDelConfirm) : true;
}

registerLoadFunc(initializeMenuItems);